attribute vec3 coord;
attribute vec2 texcoord;
#ifdef LIGHTING
attribute vec3 normal;
#endif

varying vec2 f_texcoord;
#ifdef LIGHTING
varying vec4 f_colorLightAmbient, f_colorLightDiffuse;
#endif

#ifdef FOG
varying float f_fogFactor;
varying float f_fogFactorGround;
uniform mat4 v;
#endif

#ifdef LIGHTING
	#ifdef SHADOW
		uniform int shadow_csm_index;
		uniform mat4 mvps_shadow[SHADOW_CSM_NUM];
		varying vec4 f_shadow_coord;

		#ifndef SHADOW_MAP_CORRESPONDS_SUBDIVS
		varying vec4 f_shadow_coord_far;
		varying vec3 coord_world;
		#endif

		#ifdef SHADOW_SLOPE_BIAS
		varying float f_shadow_slope_bias;
		#endif
	#endif

	#ifdef SPECULAR
	varying vec4 f_colorLightSpecular;
	uniform mat4 v_inv;
	#endif
#endif

#ifdef INSTANCING
	attribute mat4 mvp;
	#ifdef USE_MODEL_MATRIX
		attribute mat4 m;
	#endif
	#ifdef LIGHTING
		attribute mat3 m_3x3_inv_transp;
	#endif
	#ifdef TEX_ANIM
		attribute float texanim;
	#endif
#else
	uniform mat4 mvp;
	#ifdef USE_MODEL_MATRIX
		uniform mat4 m;
	#endif
	#ifdef LIGHTING
		uniform mat3 m_3x3_inv_transp;
	#endif
	#ifdef TEX_ANIM
		uniform float texanim;
	#endif
#endif



#ifdef ANIMATION
	#if WEIGHT_NUM >= 1
	attribute vec2 weight1;
	#endif
	#if WEIGHT_NUM >= 2
	attribute vec2 weight2;
	#endif
	#if WEIGHT_NUM >= 3
	attribute vec2 weight3;
	#endif
	#if WEIGHT_NUM >= 4
	attribute vec2 weight4;
	#endif
uniform mat4 bone_matrix[BONE_NUM];
#endif




void main(void)
{
	vec4 actualCoord = vec4(coord, 1.0);
	#ifdef LIGHTING
		vec4 actualNormal = vec4(normal, 0.0);
	#endif

	#ifdef ANIMATION
	vec4 newCoord = vec4(0.0, 0.0, 0.0, 1.0);
	#ifdef LIGHTING
		vec4 newNormal = vec4(0.0);
	#endif
	int index;
	float weight = 0.0, weightSum = 0.0;
		#if WEIGHT_NUM >= 1
		index = int(weight1.y);
		weight = weight1.x;
		weightSum += weight;
		newCoord += weight * (bone_matrix[index]*actualCoord);
		#ifdef LIGHTING
			newNormal += weight * (bone_matrix[index]*actualNormal);
		#endif
		#endif
		#if WEIGHT_NUM >= 2
		index = int(weight2.y);
		weight = weight2.x;
		weightSum += weight;
		newCoord += weight * (bone_matrix[index]*actualCoord);
		#ifdef LIGHTING
			newNormal += weight * (bone_matrix[index]*actualNormal);
		#endif
		#endif
		#if WEIGHT_NUM >= 3
		index = int(weight3.y);
		weight = weight3.x;
		weightSum += weight;
		newCoord += weight * (bone_matrix[index]*actualCoord);
		#ifdef LIGHTING
			newNormal += weight * (bone_matrix[index]*actualNormal);
		#endif
		#endif
		#if WEIGHT_NUM >= 4
		index = int(weight4.y);
		weight = weight4.x;
		weightSum += weight;
		newCoord += weight * (bone_matrix[index]*actualCoord);
		#ifdef LIGHTING
			newNormal += weight * (bone_matrix[index]*actualNormal);
		#endif
		#endif

	float poseFactor = max(0.0, 1.0-weightSum);
	newCoord += poseFactor * actualCoord;
	#ifdef LIGHTING
		newNormal += poseFactor * actualNormal;
	#endif
	weightSum += poseFactor;

	float weightSumInverse = 1.0/weightSum;
	actualCoord = vec4(weightSumInverse * newCoord.xyz, 1.0);
	#ifdef LIGHTING
		actualNormal = weightSumInverse * newNormal;
	#endif
	#endif

	//Position
	gl_Position = mvp * actualCoord;
	#ifdef USE_MODEL_MATRIX
	vec4 positionWorld = m * actualCoord;
	#endif

	//Towards Fragment Shader
	f_texcoord = texcoord;
#ifdef TEX_ANIM
	f_texcoord.x = (texcoord.x+texanim)*TEX_ANIM_WIDTH;
#endif

	//Lighting
#ifdef LIGHTING
	vec3 normalDirection = getNormalDirection(m_3x3_inv_transp, vec3(actualNormal));
	vec3 lightDirection = getLightDirection(currentLight.position);

	vec3 diffuseReflection = getDiffuseReflection(currentLight.diffuse, currentMaterial.diffuse, normalDirection, lightDirection);

	vec3 ambientLighting = getAmbientLighting(currentLight.ambient, currentMaterial.ambient);

	f_colorLightAmbient = vec4(ambientLighting, 1.0);
	f_colorLightDiffuse = vec4(diffuseReflection, 1.0);

	#ifdef SPECULAR
	vec3 viewDirection = getViewDirection(v_inv, positionWorld);
	vec3 specularReflection = getSpecularReflection(currentLight.specular, currentMaterial.specular, currentMaterial.shininess,
													 normalDirection, lightDirection, viewDirection);
	f_colorLightSpecular = vec4(specularReflection, 1.0);
	#endif

	#ifdef SHADOW
		#ifndef SHADOW_MAP_CORRESPONDS_SUBDIVS
			#ifndef INSTANCING
			f_shadow_coord = mvps_shadow[SHADOW_INDEX_CLOSE] * actualCoord;
			f_shadow_coord_far = mvps_shadow[SHADOW_INDEX_FAR] * actualCoord;
			#else
			f_shadow_coord = mvps_shadow[SHADOW_INDEX_CLOSE] * m * actualCoord;
			f_shadow_coord_far = mvps_shadow[SHADOW_INDEX_FAR] * m * actualCoord;
			#endif
			coord_world = positionWorld.xyz;
		#else
			#ifndef INSTANCING
			f_shadow_coord = mvps_shadow[shadow_csm_index] * actualCoord;
			#else
			f_shadow_coord = mvps_shadow[shadow_csm_index] * m * actualCoord;
			#endif
		#endif

		#ifdef SHADOW_SLOPE_BIAS
			f_shadow_slope_bias = calcShadowSlopeBiasFactorMesh(normalDirection, lightDirection);
		#endif
	#endif
#endif

#ifdef FOG
	f_fogFactor = getFogFactor(v, positionWorld);
	f_fogFactorGround = getFogFactorGround(f_fogFactor, positionWorld);
#endif


}

